/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.core;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionHelperV2 {
    private static final Map<String, Field> FIELDS_CACHE = Maps.newIdentityHashMap();
    private static final Map<String, Method> METHODS_CACHE = Maps.newIdentityHashMap();
    private static final Map<String, Constructor<?>> CONSTRUCTORS_CACHE = Maps.newIdentityHashMap();

    @Nullable
    public static Field findField(Class<?> clazz, String name) {
        return ReflectionHelperV2.findField(clazz, name, true);
    }

    @Nullable
    public static Field findField(Class<?> clazz, String name, boolean allowCache) {
        Objects.requireNonNull(clazz, "clazz was null");
        Objects.requireNonNull(name, "field name was null");
        String fieldName = ReflectionHelperV2.getFieldName(clazz, name);
        if (allowCache && FIELDS_CACHE.containsKey(fieldName)) {
            return FIELDS_CACHE.get(fieldName);
        }
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            FIELDS_CACHE.put(fieldName, field);
            return field;
        }
        catch (NoSuchFieldException e) {
            PuzzlesLib.LOGGER.warn("Unable to find field {}", (Object)fieldName, (Object)e);
            FIELDS_CACHE.put(fieldName, null);
            return null;
        }
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        return ReflectionHelperV2.findMethod(clazz, name, true, parameterTypes);
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String name, boolean allowCache, Class<?> ... parameterTypes) {
        Objects.requireNonNull(clazz, "clazz was null");
        Objects.requireNonNull(name, "method name was null");
        String methodName = ReflectionHelperV2.getMethodName(clazz, name, parameterTypes);
        if (allowCache && METHODS_CACHE.containsKey(methodName)) {
            return METHODS_CACHE.get(methodName);
        }
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            METHODS_CACHE.put(methodName, method);
            return method;
        }
        catch (NoSuchMethodException e) {
            PuzzlesLib.LOGGER.warn("Unable to find method {}", (Object)methodName, (Object)e);
            METHODS_CACHE.put(methodName, null);
            return null;
        }
    }

    @Nullable
    public static <T> Constructor<T> findConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        return ReflectionHelperV2.findConstructor(clazz, true, parameterTypes);
    }

    @Nullable
    public static <T> Constructor<T> findConstructor(Class<?> clazz, boolean allowCache, Class<?> ... parameterTypes) {
        Objects.requireNonNull(clazz, "clazz was null");
        String constructorName = ReflectionHelperV2.getConstructorName(clazz, parameterTypes);
        if (allowCache && CONSTRUCTORS_CACHE.containsKey(constructorName)) {
            return CONSTRUCTORS_CACHE.get(constructorName);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            CONSTRUCTORS_CACHE.put(constructorName, constructor);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            PuzzlesLib.LOGGER.warn("Unable to find constructor {}", (Object)constructorName, (Object)e);
            CONSTRUCTORS_CACHE.put(constructorName, null);
            return null;
        }
    }

    public static <T, E> Optional<T> getValue(Class<? super E> clazz, String name, E instance) {
        return ReflectionHelperV2.getValue(ReflectionHelperV2.findField(clazz, name), instance);
    }

    public static <T, E> boolean setValue(Class<? super E> clazz, String name, E instance, T value) {
        return ReflectionHelperV2.setValue(ReflectionHelperV2.findField(clazz, name), instance, value);
    }

    public static <T> Optional<T> getValue(@Nullable Field field, Object instance) {
        if (field != null) {
            try {
                return Optional.ofNullable(field.get(instance));
            }
            catch (IllegalAccessException e) {
                PuzzlesLib.LOGGER.warn("Unable to access field {}", (Object)ReflectionHelperV2.getFieldName(field), (Object)e);
            }
        }
        return Optional.empty();
    }

    public static <T> boolean setValue(@Nullable Field field, Object instance, T value) {
        if (field != null) {
            try {
                field.set(instance, value);
                return true;
            }
            catch (IllegalAccessException e) {
                PuzzlesLib.LOGGER.warn("Unable to access field {}", (Object)ReflectionHelperV2.getFieldName(field), (Object)e);
            }
        }
        return false;
    }

    public static <T, E> Optional<T> invokeMethod(Class<? super E> clazz, String name, Class<?>[] parameterTypes, E instance, Object[] args) {
        return ReflectionHelperV2.invokeMethod(ReflectionHelperV2.findMethod(clazz, name, parameterTypes), instance, args);
    }

    public static <T> Optional<T> invokeMethod(@Nullable Method method, Object instance, Object ... args) {
        if (method != null) {
            try {
                return Optional.ofNullable(method.invoke(instance, args));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                PuzzlesLib.LOGGER.warn("Unable to access method {}", (Object)ReflectionHelperV2.getMethodName(method), (Object)e);
            }
        }
        return Optional.empty();
    }

    public static <T, E> Optional<T> newInstance(Class<? super E> clazz, Class<?>[] parameterTypes, Object[] args) {
        return ReflectionHelperV2.newInstance(ReflectionHelperV2.findConstructor(clazz, parameterTypes), args);
    }

    public static <T> Optional<T> newInstance(@Nullable Constructor<T> constructor, Object ... args) {
        if (constructor != null) {
            try {
                return Optional.of(constructor.newInstance(args));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                PuzzlesLib.LOGGER.warn("Unable to access constructor {}", (Object)ReflectionHelperV2.getConstructorName(constructor), (Object)e);
            }
        }
        return Optional.empty();
    }

    private static String getFieldName(@NotNull Field field) {
        Objects.requireNonNull(field, "Cannot get name for null field");
        return ReflectionHelperV2.getClassMemberName(field.getDeclaringClass(), field.getName());
    }

    private static String getFieldName(Class<?> clazz, String field) {
        return ReflectionHelperV2.getClassMemberName(clazz, field);
    }

    private static String getMethodName(@NotNull Method method) {
        Objects.requireNonNull(method, "Cannot get name for null method");
        return ReflectionHelperV2.getMethodName(method.getDeclaringClass(), method.getName(), method.getParameterTypes());
    }

    private static String getConstructorName(@NotNull Constructor<?> constructor) {
        Objects.requireNonNull(constructor, "Cannot get name for null constructor");
        return ReflectionHelperV2.getConstructorName(constructor.getDeclaringClass(), constructor.getParameterTypes());
    }

    private static String getConstructorName(Class<?> clazz, Class<?> ... parameterTypes) {
        return ReflectionHelperV2.getMethodName(clazz, "<init>", parameterTypes);
    }

    private static String getMethodName(Class<?> clazz, String method, Class<?> ... parameterTypes) {
        return ReflectionHelperV2.getClassMemberName(clazz, ReflectionHelperV2.toMethodSignature(method, parameterTypes));
    }

    private static String toMethodSignature(String method, Class<?> ... parameterTypes) {
        StringJoiner sj = new StringJoiner(",", method + "(", ")");
        for (Class<?> parameterType : parameterTypes) {
            sj.add(parameterType.getTypeName());
        }
        return sj.toString();
    }

    private static String getClassMemberName(Class<?> clazz, String member) {
        return (clazz.getTypeName() + "." + member).intern();
    }
}

